// AddCard.h: interface for the CAddCard class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ADDCARD_H__F72C5EF0_F2B5_4DBB_A493_C5AFE723B228__INCLUDED_)
#define AFX_ADDCARD_H__F72C5EF0_F2B5_4DBB_A493_C5AFE723B228__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAX_ACCESSLEVELS_PER_CARD 32
// CAddCard dialog
#include <afxtempl.h>

class CAddCard : public CDialog
{
// Construction
public:
	CAddCard(CWnd* pParent = NULL);   // standard constructor
	CAddCard (IApplication *pApp);
	~CAddCard();
	bool DateValidation(COleDateTime ActDate, COleDateTime ExpDate);
// Dialog Data
	//{{AFX_DATA(CAddCard)
	enum { IDD = IDD_CARD_ADD };
	CEdit	m_ctrlNXLimits;
	CEdit	m_ctrlNXType;
	CButton	m_ctrlNXTemp;
	CButton	m_ctrlNXLimit;
	CEdit	m_ctlEditPIN1;
	CButton	m_ctrlBtBulkAdd;
	CButton	m_ctrlBtCardAdd;
	CEdit	m_ctrlCardNumEnd;
	CEdit	m_ctrlCardNumStart;
	CEdit	m_ctrlAccessLevelName;  //WUR
	CEdit	m_ctrlCardNumber;
	CListBox	m_Mul_AcclList;
	CComboBox	m_status;
	CComboBox	m_ChList;
	CComboBox	m_AccountList;
	CComboBox	m_SubAccountList;
	CComboBox	m_AccessList;
	CListBox   m_MLAccessList;   //WUR
	CString	m_CardNo;
	CString	m_CardStatus;
	CString	m_cardholder;
	CString	m_AcctName;
	CString	m_SubAcctName;
	CString	m_PIN1;
	CString	m_PIN2;
	CString	m_szActivationDate;
	CString	m_szExpirationDate;
	CString m_szMLExpirationDate;  //WUR
	CString m_szMLActivationDate;  //WUR
	BOOL	m_bIsBulkCheck;
	CString	m_szCardNumEnd;
	CString	m_szCardNumStart;
	int		m_iNXCardType;
	int		m_nNXUsageLimit;
	BOOL	m_bNXLimited;
	BOOL	m_bNXTempCard;
	int		m_nPRO3000CardType;
	int		m_iCardALCount;
	VARIANT_BOOL    m_bAccessTypeMulExpiry;
	int		m_MaxAllowedAccesslevel;  //WPACT-5689

	struct CARD_MALINFO
	{
		int	inAccessLevelID;
		time_t	ALActivationDate;
		time_t	ALExpirationDate;
	};

	CMap<CString, LPCTSTR, CARD_MALINFO, CARD_MALINFO> mapStrMALAccExpiry;
	CMap<DWORD, DWORD, CString, CString> CMALIDActDateMap;
	CMap<DWORD, DWORD, CString, CString> CMALIDExpDateMap;
//	std::map<DWORD, CARD_MALINFO>m_MLALInfoMap;	
	CARD_MALINFO	MulALExpiryInfo[MAX_ACCESSLEVELS_PER_CARD]; 
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAddCard)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CAddCard)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeAcctlist();
	afx_msg void OnSelchangeSubAcctlist();
	afx_msg void OnAddCard();
	afx_msg void OnSetALInfo();
	afx_msg void OnBulkAddcard();
	afx_msg void OnCheckBulkCardAdd();
	afx_msg void OnClickLstSelectedAccessLevel();
	
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	IApplicationPtr pApplication;
	ICardPtr	pCard;
	
	int iAccessType;
	void LoadAccounts();
	void LoadSubAccounts();
	void LoadAccessLevels();
	void LoadCardHolders();
	CString FormatDate(CTime time);
	DWORD GetAccessLevelIDFromACName(CString stAcclName);
};
//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ADDACCESSLEVEL_H__C373FD58_5382_4C3A_A864_DA16110565CF__INCLUDED_)
